/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

/*
reserved css classes

__done*
__working

*/

site = function() {
}

site.debug		= true;
site.extensions = [];
site.base		= jQuery("base").attr("href");
site.assets		= site.base + "assets/";
site.prevHeight = jQuery(window).height();
site.prevWidth	= jQuery(window).width();
site.newHeight	= jQuery(window).height();
site.newWidth	= jQuery(window).width();
site.onepage	= false;

site.registerModule = function(obj, callback) {
	this.extensions.push(obj);

	if (callback) {
		callback();
	}
}


site.runAfterLoad = function() {

	if (site.debug)	console.log("Executing afterload functions:");

	if (site.extensions.length) { 
		site.extensions.forEach(function(obj) {

			if (typeof obj.runAfterLoad != "function") 
				return false;

			if (site.debug)	console.log(obj);

		    try {
				obj.runAfterLoad();
			} catch (e) {
				getStack(0, e);
			}
		});
	}
}


site.runOnLoad = function() {

	//update site dimensions
	site.prevWidth	= site.newWidth	= jQuery(window).width(),
	site.prevHeight	= site.newHeight = jQuery(window).height();


	if (site.debug)	console.log("Executing onload functions:");

	if (site.extensions.length) { 
		site.extensions.forEach(function(obj) {

			if (typeof obj.runOnLoad != "function") 
				return false;

			if (site.debug)	console.log(obj);

		    try {
				obj.runOnLoad();
			} catch (e) {
				getStack(0, e);
			}
		});

		site.runAfterLoad();
	}
}

site.runOnReady = function() {

	if (site.debug)	console.log("Executing onready functions:");
	if (site.extensions.length) { 
		site.extensions.forEach(function(obj) {

			if (typeof obj.runOnReady != "function") 
				return false;

			if (site.debug)	console.log(obj);

		    try {
				obj.runOnReady();
			} catch (e) {
				getStack(0, e);
			}
		});
	}
}


site.runOnResize = function() {

	site.newWidth	= jQuery(window).width(),
	site.newHeight	= jQuery(window).height();

	if (site.debug)	console.log("Executing onresize functions:");

	if (site.extensions.length) { 
		site.extensions.forEach(function(obj) {

			if (typeof obj.runOnResize != "function") 
				return false;

			if (site.debug)	console.log(obj);
		    try {
				obj.runOnResize();
			} catch (e) {
				getStack(0, e);
			}
		});
	}

	site.prevHeight = site.newHeight;
	site.prevWidth	= site.newWidth;
}

site.runOnScroll = function() {
	if (site.debug)	console.log("Executing onscroll functions:");

	if (site.extensions.length) { 
		site.extensions.forEach(function(obj) {

			if (typeof obj.runOnScroll != "function") 
				return false;

			if (site.debug)	console.log(obj);
		    try {
				obj.runOnScroll();
			} catch (e) {
				getStack(0, e);
			}
		});
	}
}

site.runBeforeInitialize = function() {
	if (site.debug)	console.log("Executing initialisation");

	if (site.extensions.length) { 
		site.extensions.forEach(function(obj) {

			if (typeof obj.initialize != "function") 
				return false;

			if (site.debug)	console.log(obj);
		    try {
				obj.initialize();
			} catch (e) {
				getStack(0, e);
			}
		});
	}
}

site.runBeforeInitialize = function() {
	if (site.debug)	console.log("Executing initialisation");

	if (site.extensions.length) { 
		site.extensions.forEach(function(obj) {

			if (typeof obj.initialize != "function") 
				return false;

			if (site.debug)	console.log(obj);
		    try {
				obj.initialize();
			} catch (e) {
				getStack(0, e);
			}
		});
	}
}

site.runOnContentUpdate = function(ondone) {

	ondone = ondone || null;

	if (site.debug)	console.log("Executing onupdatecontent functions:");

	if (site.extensions.length) { 
		site.extensions.forEach(function(obj) {

			if (typeof obj.runOnContentUpdate != "function") 
				return false;

			if (site.debug)	console.log(obj);

		    try {
				obj.runOnContentUpdate();
			} catch (e) {
				getStack(0, e);
			}
		});
	}

	if (ondone !== null) {
		ondone();
	}
}


site.runOnOrientationChange = function(ondone) {

	ondone = ondone || null;

	if (site.debug)	console.log("Executing onorientationchange functions:");

	if (site.extensions.length) { 
		site.extensions.forEach(function(obj) {

			if (typeof obj.runOnOrientationChange != "function") 
				return false;

			if (site.debug)	console.log(obj);

		    try {
				obj.runOnOrientationChange();
			} catch (e) {
				getStack(0, e);
			}
		});
	}

	if (ondone !== null) {
		ondone();
	}
}

site.debug = false;
site.attachScroll = jQuery(window);

jQuery(document).ready(function() {
	site.runBeforeInitialize();
	site.runOnReady();
});


jQuery(window).load(site.runOnLoad);
jQuery(window).on("resize" , site.runOnResize);
//jQuery(window).on("orientationchange", site.runOnOrientationChange);

site.attachScroll.on("scroll" , site.runOnScroll);

function STBModule() {	
}

STBModule.prototype.name = "";
STBModule.prototype.runOnLoad = null;
STBModule.prototype.runAfterLoad = null;
STBModule.prototype.runOnReady = null;
STBModule.prototype.runOnResize = null;
STBModule.prototype.runOnScroll = null;
STBModule.prototype.runOnContentUpdate = null;
STBModule.prototype.runOnOrientationChange = null;
STBModule.prototype.initialize = null;